<?php 
require dirname(dirname(__FILE__)) . '/inc/Config.php';

$data = json_decode(file_get_contents('php://input'), true);

header('Content-type: application/json');

if(empty($data['rider_id']) || empty($data['order_id'])) {
    
    echo json_encode(array("ResponseCode"=>"400","Result"=>"false","ResponseMsg"=>"Invalid input parameters."));
} else {

    $order_id = $lundry->real_escape_string($data['order_id']);
    $rider_id =  $lundry->real_escape_string($data['rider_id']);

    try {
        // Fetch order details
        $stmt = $lundry->prepare("SELECT * FROM tbl_normal_order WHERE rid=? AND id=?");
        $stmt->bind_param("ii", $rider_id, $order_id);
        $stmt->execute();
        $row = $stmt->get_result()->fetch_assoc();
        $stmt->close();

        // Fetch rider details
        $rider_stmt = $lundry->prepare("SELECT title, img, mobile, ccode FROM tbl_rider WHERE id=?");
        $rider_stmt->bind_param("i", $row['rid']);
        $rider_stmt->execute();
        $rdata = $rider_stmt->get_result()->fetch_assoc();
        $rider_stmt->close();

        $pp = array();
        $pp['rider_title'] = $rdata['title'] ?? "";
        $pp['rider_image'] = $rdata['img'] ?? "";
        $pp['rider_mobile'] = $rdata['ccode'].$rdata['mobile'] ?? "";    
        $pp['order_id'] = $row['id'];
        $pp['order_date'] = $row['odate'];
        $pname = $lundry->query("select * from tbl_payment_list where id=".$row['p_method_id']."")->fetch_assoc();
        $pp['p_method_name'] = $pname['title'];
        $pp['customer_address'] = $row['address'];
        $pp['customer_name'] = $row['name'];
        
		$pp['wall_amt'] = $row['wall_amt'];
        $pp['customer_mobile'] = $row['mobile'];
        $pp['store_charge'] = $row['store_charge'];
        $pp['Delivery_charge'] = $row['d_charge'];
        $pp['Pickup_Timeslot'] = $row['tslot'];
		$pp['Delivery_Timeslot'] = $row['dslot'];
        $pp['Coupon_Amount'] = $row['cou_amt'];
        $pp['Order_Total'] = $row['o_total'];
        $pp['Order_SubTotal'] = $row['subtotal'];
        $pp['flow_id'] = $row['order_status'];
            $pp['Order_Transaction_id'] = $row['trans_id'];
        
        $pp['Additional_Note'] = $row['a_note'];
        $pp['Order_Status'] = $row['status'];

        // Fetch order products
        $fetchpro_stmt = $lundry->prepare("SELECT pquantity, ptitle, pdiscount, pimg, pprice, ptype FROM tbl_normal_order_product WHERE oid=?");
        $fetchpro_stmt->bind_param("i", $row['id']);
        $fetchpro_stmt->execute();
        $fetchpro_result = $fetchpro_stmt->get_result();
        
        $pdata = array();
        while($jpro = $fetchpro_result->fetch_assoc())
        {
            $kop = array();
            $kop['Product_quantity'] = $jpro['pquantity'];
            $kop['Product_name'] = $jpro['ptitle'];
            $kop['Product_discount'] = $jpro['pdiscount'];
            $kop['Product_image'] = $jpro['pimg'];
            $kop['Product_price'] = $jpro['pprice'];
            $kop['Product_type'] = $jpro['ptype'];
            array_push($pdata, $kop);
        }

        $pp['order_products'] = $pdata;

        
        echo json_encode(array("ResponseCode"=>"200","Result"=>"true","ResponseMsg"=>"Order details fetched successfully.","orderdata"=>$pp));

    } catch (Exception $e) {
        
        echo json_encode(array("ResponseCode"=>"500","Result"=>"false","ResponseMsg"=>"Error occurred while fetching order details.","orderdata"=>[]));
    }
}